/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.renderers.notebook;

import com.ibm.hwmca.fw.servlet.renderers.notebook.CustomWNotebook;
import com.ibm.psw.wcl.components.notebook.WNotebook;
import com.ibm.psw.wcl.components.notebook.WNotebookComponent;
import com.ibm.psw.wcl.components.notebook.WNotebookPage;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.form.AWInputComponent;
import com.ibm.psw.wcl.core.form.WForm;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.renderer.output.html.HTMLDocumentFragmentWrapper;
import com.ibm.psw.wcl.core.renderer.output.html.IHTMLDocumentFragmentOutput;
import com.ibm.psw.wcl.renderers.core.html.HTMLComponentRenderer;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLDivElement;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLImageElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class CustomHTMLNotebookComponentRenderer
extends HTMLComponentRenderer {
    public IOutput render(RenderingContext rc, Object renderObject) throws RendererException {
        if (!(renderObject instanceof WNotebookComponent)) {
            throw new RendererException("Render object is not a WNotebookComponent.");
        }
        WNotebookComponent nbComponent = (WNotebookComponent)renderObject;
        switch (nbComponent.getType()) {
            case 1: {
                HTMLDocumentFragmentWrapper doc = rc.getDocumentFactory().createHTMLDocumentFragmentWrapper();
                doc.appendToContentFragment((Node)this.createNotebookTabs(rc, doc, nbComponent));
                return doc.createOutput(rc);
            }
            case 2: {
                return nbComponent.getContainer().getOutput(rc);
            }
            case 3: {
                HTMLDocumentFragmentWrapper doc = rc.getDocumentFactory().createHTMLDocumentFragmentWrapper();
                doc.appendToContentFragment((Node)this.createNotebookButtons(rc, doc, nbComponent));
                return doc.createOutput(rc);
            }
        }
        throw new RendererException("Notebook component type " + nbComponent.getType() + " is unknown");
    }

    protected HTMLElement createNotebookTabs(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WNotebookComponent nbComp) throws RendererException {
        WNotebook notebook = nbComp.getNotebook();
        ResourceBundle rb = ResourceBundle.getBundle("com.ibm.psw.wcl.nls.WclInternalResources", rc.getLocale());
        HTMLTableElement table = doc.createTABLEElement();
        table.setCellSpacing("0");
        table.setCellPadding("0");
        int tabDirection = 0;
        if (notebook instanceof CustomWNotebook) {
            tabDirection = ((CustomWNotebook)notebook).getTabDirection();
        }
        if (tabDirection == 2 || tabDirection == 3) {
            HTMLTableRowElement tr = doc.createTRElement();
            Enumeration enumeration = notebook.getPages();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                WNotebookPage page = (WNotebookPage)enumeration.nextElement();
                boolean tabIsSelected = notebook.getCurrentPageIndex() == i;
                boolean tabIsFirst = i == 0;
                HTMLTableCellElement td = doc.createTDElement();
                tr.appendChild(td);
                td.setTitle(page.getDescription());
                td.setClassName(this.getFirstClassNames(tabDirection, tabIsFirst, tabIsSelected));
                td.appendChild(this.createTabFirstPart(rb, rc, doc, notebook, page, i));
                td = doc.createTDElement();
                tr.appendChild(td);
                td.setTitle(page.getDescription());
                td.setClassName(this.getSecondClassNames(tabDirection, tabIsFirst, tabIsSelected));
                td.appendChild(this.createTabSecondPart(rc, doc, notebook, true));
                ++i;
            }
            table.appendChild(tr);
        } else {
            Enumeration enumeration = notebook.getPages();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                WNotebookPage page = (WNotebookPage)enumeration.nextElement();
                boolean tabIsSelected = notebook.getCurrentPageIndex() == i;
                boolean tabIsFirst = i == 0;
                HTMLTableRowElement tr = doc.createTRElement();
                table.appendChild(tr);
                HTMLTableCellElement td = doc.createTDElement();
                tr.appendChild(td);
                td.setTitle(page.getDescription());
                td.setClassName(this.getFirstClassNames(tabDirection, tabIsFirst, tabIsSelected));
                td.appendChild(this.createTabFirstPart(rb, rc, doc, notebook, page, i));
                tr = doc.createTRElement();
                table.appendChild(tr);
                td = doc.createTDElement();
                tr.appendChild(td);
                td.setTitle(page.getDescription());
                td.setClassName(this.getSecondClassNames(tabDirection, tabIsFirst, tabIsSelected));
                td.appendChild(this.createTabSecondPart(rc, doc, notebook, false));
                ++i;
            }
        }
        return table;
    }

    protected HTMLElement createNotebookButtons(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WNotebookComponent nbComp) throws RendererException {
        HTMLDivElement div = doc.createDIVElement();
        IOutput o = nbComp.getContainer().getOutput(rc);
        ((IHTMLDocumentFragmentOutput)o).appendContentFragment((Node)div);
        ((IHTMLDocumentFragmentOutput)o).appendHeadFragment((Node)doc.getHeadFragment());
        this.renderCssStyles(rc, (WComponent)nbComp.getNotebook(), div, "nb7");
        return div;
    }

    private HTMLElement createTabFirstPart(ResourceBundle rb, RenderingContext rc, HTMLDocumentFragmentWrapper doc, WNotebook notebook, WNotebookPage page, int index) throws RendererException {
        HTMLDivElement div = doc.createDIVElement();
        String action = "turnPage(" + index + ')';
        boolean current = index == notebook.getCurrentPageIndex();
        HTMLAnchorElement anchor = this.createAnchorTag(rc, doc, notebook, action);
        div.appendChild(anchor);
        anchor.setAttribute("accessKey", page.getAccessKey());
        anchor.appendChild(doc.createTextNode(page.getTabText()));
        return div;
    }

    private HTMLElement createTabSecondPart(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WNotebook notebook, boolean topOrBottom) throws RendererException {
        HTMLImageElement image = doc.createIMGElement();
        image.setSrc(this.getImageValue(rc, (WComponent)notebook, "IMG_BLANK"));
        image.setHeight(topOrBottom ? "1" : "9");
        image.setWidth(topOrBottom ? "9" : "1");
        return image;
    }

    private HTMLAnchorElement createAnchorTag(RenderingContext rc, HTMLDocumentFragmentWrapper doc, WNotebook notebook, String action) throws RendererException {
        HTMLAnchorElement anchor = doc.createAElement();
        AWInputComponent actionComp = notebook.getInputComponent("action");
        WForm form = AWInputComponent.findWForm((WComponent)actionComp);
        anchor.setHref("#");
        if (notebook.isFeatureEnabled(2)) {
            if (notebook.isAnchoring()) {
                anchor.setAttribute("onClick", "return doNb('" + rc.encodeName(form.getName()) + "', '" + actionComp.getName() + "', '" + action + "', '" + rc.encodeName(actionComp.getName()) + "', '" + rc.encodeName("wh") + "', '" + rc.encodeName("wa") + "');");
            } else {
                anchor.setAttribute("onClick", "return doNb('" + rc.encodeName(form.getName()) + "', '" + actionComp.getName() + "', '" + action + "', '" + rc.encodeName(actionComp.getName()) + "', '" + rc.encodeName("wh") + "', null);");
            }
        }
        return anchor;
    }

    private String getFirstClassNames(int tabDirection, boolean tabIsFirst, boolean tabIsSelected) {
        StringBuffer allClasses = new StringBuffer(70);
        allClasses.append(tabIsSelected ? "tabSelected" : "tabNotSelected");
        if (tabDirection == 2 || tabDirection == 3) {
            if (tabDirection == 2) {
                allClasses.append(" tabMargins ");
            } else {
                allClasses.append(" tabMarginsBottom tabBgBottom ");
            }
            if (tabIsFirst) {
                allClasses.append(tabIsSelected ? "tabBgSelectedFirstLeft" : "tabBgNotSelectedFirstLeft");
            } else {
                allClasses.append(tabIsSelected ? "tabBgSelectedLeft" : "tabBgNotSelectedLeft");
            }
        } else {
            if (tabDirection == 0) {
                allClasses.append(" tabMarginsLeft ");
            } else {
                allClasses.append(" tabMarginsRight tabBgRight ");
            }
            if (tabIsFirst) {
                allClasses.append(tabIsSelected ? "tabBgSelectedFirstLeft" : "tabBgNotSelectedFirstLeft");
            } else {
                allClasses.append(tabIsSelected ? "tabBgSelectedTop" : "tabBgNotSelectedTop");
            }
        }
        return allClasses.toString();
    }

    private String getSecondClassNames(int tabDirection, boolean tabIsFirst, boolean tabIsSelected) {
        StringBuffer allClasses = new StringBuffer(70);
        if (tabDirection == 2) {
            allClasses.append(tabIsSelected ? "tabBgSelectedRight" : "tabBgNotSelectedRight");
        } else if (tabDirection == 3) {
            allClasses.append(tabIsSelected ? "tabBgSelectedRight" : "tabBgNotSelectedRight");
            allClasses.append(" tabBgBottom");
        } else if (tabDirection == 0) {
            allClasses.append(tabIsSelected ? "tabBgSelectedBottom" : "tabBgNotSelectedBottom");
        } else if (tabDirection == 1) {
            allClasses.append(tabIsSelected ? "tabBgSelectedBottom" : "tabBgNotSelectedBottom");
            allClasses.append(" tabBgRight");
        }
        return allClasses.toString();
    }
}

